package parser;

/**
 * Grammar non-terminal -- E ::= F E1
 */
public class E {
    /**
     * F object.
     */
    private F _f;

    /**
     * E1 object.
     */
    private E1 _e1;

    /**
     * Constructor for the E grammar non-terminal.
     *
     * @param f  F object
     * @param e1 E1 object
     */
    public E(F f, E1 e1) {
        _f = f;
        _e1 = e1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _f.toString() + _e1.toString();
    }
}

